/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.rmi.RemoteException;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Real;
import visad.RemoteDataReferenceImpl;
import visad.VisADException;
import visad.formula.FormulaManager;
import visad.ss.BasicSSCell;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellImpl;
import visad.util.DataUtility;
import visad.util.Util;

public class SSCellData {
    BasicSSCell ssCell;
    private int id;
    private DataReferenceImpl ref;
    private ConstantMap[] cmaps;
    private RemoteDataReferenceImpl remoteRef;
    private String source;
    private int type;
    private String cellName;
    private String varName;
    private String[] errors;
    private FormulaManager fm;
    boolean othersDepend;
    SSCellImpl cell;

    public SSCellData(int id, BasicSSCell ssCell, DataReferenceImpl ref, ConstantMap[] cmaps, String source, int type, boolean checkErrors) throws VisADException, RemoteException {
        this.ssCell = ssCell;
        this.id = id;
        this.ref = ref;
        this.remoteRef = new RemoteDataReferenceImpl(ref);
        this.source = source;
        this.type = type;
        this.cellName = ssCell.getName();
        this.varName = this.cellName + "d" + id;
        this.errors = new String[0];
        this.othersDepend = false;
        this.fm = ssCell.getFormulaManager();
        this.fm.setReference(this.varName, ref);
        if (this.id == 1) {
            this.fm.setReference(this.cellName, ref);
        }
        this.cell = new SSCellImpl(this, ref, this.varName, checkErrors);
    }

    public int getId() {
        return this.id;
    }

    public Data getData() {
        return this.ref.getData();
    }

    public DataReferenceImpl getReference() {
        return this.ref;
    }

    public ConstantMap[] getConstantMaps() {
        return this.cmaps;
    }

    public RemoteDataReferenceImpl getRemoteReference() {
        return this.remoteRef;
    }

    public String getSource() {
        return this.source;
    }

    public int getSourceType() {
        return this.type;
    }

    public String getVariableName() {
        return this.varName;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public boolean othersDepend() {
        return this.othersDepend;
    }

    public boolean isInited() {
        return this.cell.isInited();
    }

    public void setData(Data data) throws VisADException, RemoteException {
        this.setData(data, true);
    }

    void setData(Data data, boolean notify) throws VisADException, RemoteException {
        DataImpl d2 = data.local();
        if (!notify) {
            this.cell.skipNextNotify();
        }
        this.ref.setData(d2);
    }

    public void setError(String error) {
        this.setErrors(new String[]{error}, true, true);
    }

    public void setErrors(String[] errors) {
        this.setErrors(errors, true, true);
    }

    void setErrors(String[] errors, boolean notify) {
        this.setErrors(errors, notify, true);
    }

    void setErrors(String[] errors, boolean notify, boolean update) {
        block4: {
            if (Util.arraysEqual(this.errors, errors)) {
                return;
            }
            this.errors = errors;
            if (update) {
                this.ssCell.updateDisplay();
            }
            if (!notify) break block4;
            try {
                this.ssCell.sendMessage(5, this.varName, DataUtility.stringsToTuple(errors, BasicSSCell.DEBUG));
            }
            catch (RemoteException exc) {
                if (!BasicSSCell.DEBUG) break block4;
                exc.printStackTrace();
            }
        }
    }

    public void setDependencies(Real real) {
        this.othersDepend = real.equals(SSCellImpl.TRUE);
    }

    public void destroy() {
        block10: {
            block9: {
                try {
                    this.fm.setThing(this.varName, null);
                    if (this.id == 1) {
                        this.fm.setThing(this.cellName, null);
                    }
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block9;
                    exc.printStackTrace();
                }
            }
            try {
                this.cell.removeAllReferences();
            }
            catch (VisADException exc) {
                if (BasicSSCell.DEBUG) {
                    exc.printStackTrace();
                }
            }
            catch (RemoteException exc) {
                if (!BasicSSCell.DEBUG) break block10;
                exc.printStackTrace();
            }
        }
        this.cell.stop();
        this.cell = null;
        this.ssCell.notifySSCellListeners(SSCellChangeEvent.DATA_CHANGE, this.varName);
    }
}

