/*
 * Decompiled with CFR 0.152.
 */
package csplugins.sbw;

import csplugins.sbw.Reaction;
import csplugins.sbw.Species;
import java.util.Vector;

public class Model {
    String name;
    Vector speciesList;
    Vector reactionList;

    public Model() {
        this(null);
    }

    public Model(String string) {
        this.name = string;
        this.speciesList = new Vector();
        this.reactionList = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void addSpecies(Species species) {
        this.speciesList.add(species);
    }

    public void addReaction(Reaction reaction) {
        this.reactionList.add(reaction);
    }

    public Vector getSpecies() {
        return this.speciesList;
    }

    public Species[] getSpeciesListAsArray() {
        return this.speciesList.toArray(new Species[0]);
    }

    public Vector getReaction() {
        return this.reactionList;
    }

    public Reaction[] getReactionListAsArray() {
        return this.reactionList.toArray(new Reaction[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Model '" + this.name + "'");
        stringBuffer.append("\n\n");
        Species[] speciesArray = this.getSpeciesListAsArray();
        for (int i = 0; i < speciesArray.length; ++i) {
            stringBuffer.append("  " + speciesArray[i].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        Reaction[] reactionArray = this.getReactionListAsArray();
        for (int i = 0; i < reactionArray.length; ++i) {
            stringBuffer.append(reactionArray[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

