/*
 * Decompiled with CFR 0.152.
 */
package csplugins.sbw;

import csplugins.sbw.KineticLaw;
import java.util.Vector;

public class Reaction {
    String name;
    boolean reversible = false;
    boolean fast = false;
    Vector reactants;
    Vector products;
    KineticLaw kineticLaw;

    public Reaction(String string) {
        this(string, false, false);
    }

    public Reaction(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.reversible = bl;
        this.fast = bl2;
        this.reactants = new Vector();
        this.products = new Vector();
        this.kineticLaw = null;
    }

    public void setReversible(boolean bl) {
        this.reversible = bl;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public void setKineticLaw(KineticLaw kineticLaw) {
        this.kineticLaw = kineticLaw;
    }

    public void addReactant(String string) {
        if (!this.reactants.contains(string)) {
            this.reactants.add(string);
        }
    }

    public void addProduct(String string) {
        if (!this.products.contains(string)) {
            this.products.add(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public KineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public boolean getReversible() {
        return this.reversible;
    }

    public boolean getFast() {
        return this.fast;
    }

    public Vector getReactants() {
        return this.reactants;
    }

    public String[] getReactantsAsStringArray() {
        return this.reactants.toArray(new String[0]);
    }

    public Vector getProducts() {
        return this.products;
    }

    public String[] getProductsAsStringArray() {
        return this.products.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Reaction " + this.name + ": ");
        stringBuffer.append("  (reversible = " + this.reversible + ")  (fast = " + this.fast + ")");
        stringBuffer.append("\n");
        stringBuffer.append("  kinetic law: " + this.kineticLaw);
        stringBuffer.append("\n");
        stringBuffer.append("  reactants: ");
        String[] stringArray = this.reactants.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("  products: ");
        String[] stringArray2 = this.products.toArray(new String[0]);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(stringArray2[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

