/*
 * Decompiled with CFR 0.152.
 */
package csplugins.sbw;

import b.a.g;
import b.a.t;
import b.i.aa;
import csplugins.sbw.Model;
import csplugins.sbw.Reaction;
import csplugins.sbw.Species;
import csplugins.sbw.readers.SbmlReader;
import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SBMLPlugin
extends AbstractPlugin {
    protected CytoscapeWindow cytoscapeWindow;
    File currentDirectory;
    HashMap nodeHash = new HashMap();
    Model model;
    String fullSbmlText;

    public SBMLPlugin(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        String[] stringArray = cytoscapeWindow.getConfiguration().getArgs();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--sbml")) continue;
            string = stringArray[i + 1];
        }
        if (string != null && string.length() > 0) {
            this.loadSbmlFile(string);
        }
        this.currentDirectory = new File(System.getProperty("user.dir"));
        JMenuBar jMenuBar = cytoscapeWindow.getMenuBar();
        boolean bl = false;
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            String string2 = jMenu.getText();
            if (!string2.equalsIgnoreCase("File")) continue;
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (!jMenuItem.isEnabled() || !jMenuItem.getText().equalsIgnoreCase("Load")) continue;
                JMenu jMenu2 = (JMenu)jMenuItem;
                jMenu2.add(new a());
                bl = true;
            }
        }
        if (!bl) {
            String string3 = "Could not find 'File->Load' menu, to add 'Load SBML...' menu";
            JOptionPane.showMessageDialog(null, string3, "Error!", 0);
        }
    }

    protected void loadSbmlFile(String string) {
        try {
            SbmlReader sbmlReader = new SbmlReader(new File(string));
            this.model = sbmlReader.getModel();
            this.fullSbmlText = sbmlReader.getText();
            this.displayModel();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Exception while reading SBML file ");
            stringBuffer.append(string);
            stringBuffer.append(".  ");
            stringBuffer.append("Please email a copy to ");
            stringBuffer.append("bugs@cytoscape.org");
            JOptionPane.showMessageDialog(null, stringBuffer.toString(), "Error!", 0);
            exception.printStackTrace();
        }
    }

    protected void displayModel() throws Exception {
        String string;
        if (this.model == null) {
            return;
        }
        Species[] speciesArray = this.model.getSpeciesListAsArray();
        aa aa2 = this.cytoscapeWindow.getGraph();
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        for (int i = 0; i < speciesArray.length; ++i) {
            Species species = speciesArray[i];
            string = species.getName();
            double d = species.getInitialAmount();
            boolean bl = species.getBoundaryCondition();
            String string2 = species.getCompartment();
            t t2 = aa2.a(0.0, 0.0, 70.0, 30.0, string);
            graphObjAttributes.set("nodeType", string, (Object)"species");
            graphObjAttributes.addNameMapping(string, (Object)t2);
            this.nodeHash.put(string, t2);
        }
        Reaction[] reactionArray = this.model.getReactionListAsArray();
        for (int i = 0; i < reactionArray.length; ++i) {
            string = reactionArray[i].getName();
            t t3 = aa2.a(0.0, 0.0, 70.0, 30.0, string);
            graphObjAttributes.set("nodeType", string, (Object)"reaction");
            graphObjAttributes.addNameMapping(string, (Object)t3);
            this.nodeHash.put(string, t3);
        }
        this.createEdges();
        this.cytoscapeWindow.redrawGraph(true);
    }

    protected void createEdges() throws Exception {
        if (this.model == null) {
            return;
        }
        aa aa2 = this.cytoscapeWindow.getGraph();
        Reaction[] reactionArray = this.model.getReactionListAsArray();
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getEdgeAttributes();
        for (int i = 0; i < reactionArray.length; ++i) {
            String string;
            g g2;
            String string2;
            String string3 = reactionArray[i].getName();
            String[] stringArray = reactionArray[i].getReactantsAsStringArray();
            if (!this.nodeHash.containsKey(string3)) {
                System.err.println("no reaction node for name '" + string3 + "'");
                continue;
            }
            t t2 = (t)this.nodeHash.get(string3);
            for (int j = 0; j < stringArray.length; ++j) {
                String string4 = stringArray[j];
                if (!this.nodeHash.containsKey(string4)) {
                    System.err.println("no reactant node for name '" + string4 + "'");
                    continue;
                }
                string2 = (t)this.nodeHash.get(stringArray[j]);
                g2 = aa2.a((t)string2, t2);
                string = string4 + " (reactantFor) " + string3;
                graphObjAttributes.set("interaction", string, (Object)"reactantFor");
                graphObjAttributes.addNameMapping(string, (Object)g2);
            }
            String[] stringArray2 = reactionArray[i].getProductsAsStringArray();
            for (int j = 0; j < stringArray2.length; ++j) {
                string2 = stringArray2[j];
                if (!this.nodeHash.containsKey(string2)) {
                    System.err.println("no product node for name '" + string2 + "'");
                    continue;
                }
                g2 = (t)this.nodeHash.get(stringArray2[j]);
                string = aa2.a(t2, (t)g2);
                String string5 = string3 + " (produces) " + string2;
                graphObjAttributes.set("interaction", string5, (Object)"produces");
                graphObjAttributes.addNameMapping(string5, (Object)string);
            }
        }
    }

    protected class a
    extends AbstractAction {
        a() {
            super("<html>SBML... <i><font color='red'>(experimental)</font></i></html>");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(SBMLPlugin.this.currentDirectory);
            if (jFileChooser.showOpenDialog((Component)SBMLPlugin.this.cytoscapeWindow) == 0) {
                SBMLPlugin.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                SBMLPlugin.this.loadSbmlFile(string);
            }
        }
    }
}

