/*
 * Decompiled with CFR 0.152.
 */
package csplugins.sbw;

import b.a.g;
import b.a.t;
import b.i.aa;
import csplugins.sbw.Model;
import csplugins.sbw.Reaction;
import csplugins.sbw.SbwGibsonSimulatorProxy;
import csplugins.sbw.SbwTrigProxy;
import csplugins.sbw.Species;
import csplugins.sbw.readers.SbmlReader;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import edu.caltech.sbw.Module;
import edu.caltech.sbw.SBW;
import edu.caltech.sbw.SBWException;
import edu.caltech.sbw.Service;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SbwDemo {
    protected CytoscapeWindow cytoscapeWindow;
    File currentDirectory;
    Model model;
    HashMap nodeHash = new HashMap();
    double angle = 1.5;
    SbwTrigProxy trigProxy;
    SbwGibsonSimulatorProxy gibsonProxy;
    String fullSbmlText;
    static /* synthetic */ Class class$csplugins$sbw$SbwTrigProxy;
    static /* synthetic */ Class class$csplugins$sbw$SbwGibsonSimulatorProxy;

    public SbwDemo(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        cytoscapeWindow.getOperationsMenu().add(new a());
        this.currentDirectory = new File(System.getProperty("user.dir"));
    }

    protected boolean initSBW() {
        System.out.print("connecting to SBW...");
        System.out.flush();
        try {
            SBW.connect();
            System.out.println("  connected");
            System.out.println("getting edu.caltech.trigj");
            Module module = SBW.getModuleInstance((String)"edu.caltech.trigj");
            System.out.println("looking up trig service");
            Service service = module.findServiceByName("Trig");
            System.out.println("getting the trig proxy");
            this.trigProxy = (SbwTrigProxy)service.getServiceObject(class$csplugins$sbw$SbwTrigProxy == null ? (class$csplugins$sbw$SbwTrigProxy = SbwDemo.class$("csplugins.sbw.SbwTrigProxy")) : class$csplugins$sbw$SbwTrigProxy);
            System.out.println("getting edu.caltech.gibson.gui");
            Module module2 = SBW.getModuleInstance((String)"edu.caltech.gibson.gui");
            System.out.println("looking up the gibson service");
            Service service2 = module2.findServiceByName("gibson");
            System.out.println("getting the gibson ui proxy");
            this.gibsonProxy = (SbwGibsonSimulatorProxy)service2.getServiceObject(class$csplugins$sbw$SbwGibsonSimulatorProxy == null ? (class$csplugins$sbw$SbwGibsonSimulatorProxy = SbwDemo.class$("csplugins.sbw.SbwGibsonSimulatorProxy")) : class$csplugins$sbw$SbwGibsonSimulatorProxy);
            System.out.println("---- succesful");
        }
        catch (Exception exception) {
            System.out.println("  failed " + exception.getMessage());
            return false;
        }
        return true;
    }

    protected void displayModel() {
        String string;
        if (this.model == null) {
            return;
        }
        Species[] speciesArray = this.model.getSpeciesListAsArray();
        aa aa2 = this.cytoscapeWindow.getGraph();
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        for (int i = 0; i < speciesArray.length; ++i) {
            Species species = speciesArray[i];
            string = species.getName();
            double d = species.getInitialAmount();
            boolean bl = species.getBoundaryCondition();
            String string2 = species.getCompartment();
            System.out.println(string);
            t t2 = aa2.a(0.0, 0.0, 70.0, 30.0, string);
            graphObjAttributes.set("nodeType", string, (Object)"species");
            graphObjAttributes.addNameMapping(string, (Object)t2);
            this.nodeHash.put(string, t2);
        }
        Reaction[] reactionArray = this.model.getReactionListAsArray();
        for (int i = 0; i < reactionArray.length; ++i) {
            string = reactionArray[i].getName();
            t t3 = aa2.a(0.0, 0.0, 70.0, 30.0, string);
            graphObjAttributes.set("nodeType", string, (Object)"reaction");
            graphObjAttributes.addNameMapping(string, (Object)t3);
            this.nodeHash.put(string, t3);
        }
        this.createEdges();
        this.cytoscapeWindow.redrawGraph(true);
    }

    protected void createEdges() {
        if (this.model == null) {
            return;
        }
        try {
            aa aa2 = this.cytoscapeWindow.getGraph();
            Reaction[] reactionArray = this.model.getReactionListAsArray();
            GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getEdgeAttributes();
            for (int i = 0; i < reactionArray.length; ++i) {
                String string;
                g g2;
                String string2;
                String string3 = reactionArray[i].getName();
                String[] stringArray = reactionArray[i].getReactantsAsStringArray();
                System.out.println("---- creating edges into reaction: " + string3);
                if (!this.nodeHash.containsKey(string3)) {
                    System.err.println("no reaction node for name '" + string3 + "'");
                    continue;
                }
                t t2 = (t)this.nodeHash.get(string3);
                for (int j = 0; j < stringArray.length; ++j) {
                    String string4 = stringArray[j];
                    System.out.println("---- creating edges from reactant: " + string4);
                    if (!this.nodeHash.containsKey(string4)) {
                        System.err.println("no reactant node for name '" + string4 + "'");
                        continue;
                    }
                    string2 = (t)this.nodeHash.get(stringArray[j]);
                    g2 = aa2.a((t)string2, t2);
                    string = string4 + " (reactantFor) " + string3;
                    graphObjAttributes.set("interaction", string, (Object)"reactantFor");
                    graphObjAttributes.addNameMapping(string, (Object)g2);
                }
                String[] stringArray2 = reactionArray[i].getProductsAsStringArray();
                for (int j = 0; j < stringArray2.length; ++j) {
                    string2 = stringArray2[j];
                    System.out.println("---- creating edges from product: " + string2);
                    if (!this.nodeHash.containsKey(string2)) {
                        System.err.println("no product node for name '" + string2 + "'");
                        continue;
                    }
                    g2 = (t)this.nodeHash.get(stringArray2[j]);
                    string = aa2.a(t2, (t)g2);
                    String string5 = string3 + " (produces) " + string2;
                    graphObjAttributes.set("interaction", string5, (Object)"produces");
                    graphObjAttributes.addNameMapping(string5, (Object)string);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class a
    extends AbstractAction {
        a() {
            super("Load SBML");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(SbwDemo.this.currentDirectory);
            if (jFileChooser.showOpenDialog((Component)SbwDemo.this.cytoscapeWindow) == 0) {
                SbwDemo.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                try {
                    SbmlReader sbmlReader = new SbmlReader(new File(string));
                    SbwDemo.this.model = sbmlReader.getModel();
                    SbwDemo.this.fullSbmlText = sbmlReader.getText();
                    System.out.println(SbwDemo.this.model);
                    SbwDemo.this.displayModel();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getMessage() + exception, "Error!", 0);
                    exception.printStackTrace();
                }
            }
        }
    }

    protected class c
    extends AbstractAction {
        c() {
            super("Run Gibson Simulator");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SbwDemo.this.fullSbmlText == null || SbwDemo.this.fullSbmlText.length() == 0) {
                return;
            }
            try {
                System.out.println("run gibson");
                SbwDemo.this.gibsonProxy.doAnalysis(SbwDemo.this.fullSbmlText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class b
    extends AbstractAction {
        b() {
            super("Test SBW: call Trig.sin ()");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                double d = SbwDemo.this.trigProxy.sin(SbwDemo.this.angle);
                System.out.println("--- sin (" + SbwDemo.this.angle + ") = " + d);
                SbwDemo.this.angle += 0.15;
            }
            catch (SBWException sBWException) {
                sBWException.handleWithDialog();
            }
        }
    }
}

