/*
 * Decompiled with CFR 0.152.
 */
package csplugins.sbw.readers;

import csplugins.sbw.KineticLaw;
import csplugins.sbw.Model;
import csplugins.sbw.Reaction;
import csplugins.sbw.Species;
import cytoscape.data.readers.TextFileReader;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SbmlReader {
    File xmlFile;
    Model model;
    File directoryAbsolute;
    Namespace sbns;
    String fullXmlText;

    public SbmlReader(File file) throws Exception {
        if (!file.canRead()) {
            System.err.println("---- csplugins.sbml.simple.readers.SbmlReader error, cannot read file: ");
            System.err.println("        " + file);
            throw new Exception("cannot read input: " + file);
        }
        this.xmlFile = file;
        this.directoryAbsolute = file.getAbsoluteFile().getParentFile();
        this.a();
    }

    private void a() throws Exception {
        TextFileReader textFileReader = new TextFileReader(this.xmlFile.getPath());
        textFileReader.read();
        this.fullXmlText = textFileReader.getText();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(this.xmlFile);
        Element element = document.getRootElement();
        this.sbns = Namespace.getNamespace((String)"http://www.sbml.org/sbml/level1");
        Element element2 = element.getChild("model", this.sbns);
        String string = element2.getAttributeValue("name");
        this.model = new Model(string);
        this.getSpecies(element2);
        this.if(element2);
    }

    public void getSpecies(Element element) {
        Element element2 = element.getChild("listOfSpecies", this.sbns);
        if (element2 == null) {
            return;
        }
        List list = element2.getChildren("specie", this.sbns);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element3 = (Element)listIterator.next();
            String string = element3.getAttributeValue("name");
            String string2 = element3.getAttributeValue("boundaryCondition");
            boolean bl = false;
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                bl = true;
            }
            string2 = element3.getAttributeValue("initialAmount");
            double d = 0.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string3 = element3.getAttributeValue("compartment");
            Species species = new Species(string, bl, d, string3);
            this.model.addSpecies(species);
        }
    }

    private void if(Element element) {
        Element element2 = element.getChild("listOfReactions", this.sbns);
        if (element2 == null) {
            return;
        }
        List list = element2.getChildren("reaction", this.sbns);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element3 = (Element)listIterator.next();
            this.a(element3);
        }
    }

    private void a(Element element) {
        Object object;
        String string;
        String string2;
        Element element2;
        String string3 = element.getAttributeValue("name");
        boolean bl = true;
        String string4 = element.getAttributeValue("reversible");
        if (string4 != null) {
            bl = element.getAttributeValue("reversible").equalsIgnoreCase("true");
        }
        boolean bl2 = false;
        string4 = element.getAttributeValue("fast");
        if (string4 != null) {
            bl2 = string4.equalsIgnoreCase("true");
        }
        Reaction reaction = new Reaction(string3, bl, bl2);
        Element element3 = element.getChild("listOfReactants", this.sbns);
        if (element3 == null) {
            return;
        }
        List list = element3.getChildren("specieReference", this.sbns);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            element2 = (Element)listIterator.next();
            string2 = element2.getAttributeValue("specie");
            string = element2.getAttributeValue("stoichiometry");
            reaction.addReactant(string2);
        }
        element2 = element.getChild("listOfProducts", this.sbns);
        if (element2 == null) {
            return;
        }
        list = element2.getChildren("specieReference", this.sbns);
        if (list == null) {
            return;
        }
        listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string2 = (Element)listIterator.next();
            string = string2.getAttributeValue("specie");
            object = string2.getAttributeValue("stoichiometry");
            reaction.addProduct(string);
        }
        string2 = element.getChild("kineticLaw", this.sbns);
        if (string2 != null) {
            string = string2.getAttributeValue("formula");
            object = new KineticLaw(string);
            Element element4 = string2.getChild("listOfParameters", this.sbns);
            if (element4 != null && (list = element4.getChildren("parameter", this.sbns)) != null) {
                listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    Element element5 = (Element)listIterator.next();
                    String string5 = element5.getAttributeValue("name");
                    String string6 = element5.getAttributeValue("value");
                    try {
                        ((KineticLaw)object).addParameter(string5, new Double(string6));
                    }
                    catch (Exception exception) {
                        System.err.println("number format exception, trying to make double of '" + string6 + "'");
                    }
                }
            }
            reaction.setKineticLaw((KineticLaw)object);
        }
        this.model.addReaction(reaction);
    }

    public String getText() {
        return this.fullXmlText;
    }

    public Model getModel() {
        return this.model;
    }
}

